/* tailor.h -- target dependent definitions
 * Copyright (C) 1992-1993 Jean-loup Gailly.
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License, see the file COPYING.
 */

/* The target dependent definitions should be defined here only.
 * The target dependent functions should be defined in tailor.c.
 */

/* $Id: tailor.h,v 0.18 1993/06/14 19:32:20 jloup Exp $ */


#define HAVE_SYS_UTIME_H
#define NO_UTIME_H
#define PATH_SEP2 '\\'
#define PATH_SEP3 ':'
#define MAX_PATH_LEN  260
#define NO_CHOWN
#define PROTO
#define STDC_HEADERS
#define SET_BINARY_MODE(fd) setmode(fd, O_BINARY)
#include <io.h>
#include <malloc.h>
#ifdef NTFAT
#  define NO_MULTIPLE_DOTS
#  define MAX_EXT_CHARS 3
#  define Z_SUFFIX "z"
#  define casemap(c) tolow(c) /* Force file names to lower case */
#endif
#define OS_CODE  0x0b


//#if defined(pyr) && !defined(NOMEMCPY) /* Pyramid */
//#  define NOMEMCPY /* problem with overlapping copies */
//#endif

#define NO_ST_INO /* don't rely on inode numbers */

#define PATH_SEP '\\'

#ifndef casemap
#  define casemap(c) (c)
#endif

#ifndef OPTIONS_VAR
#  define OPTIONS_VAR "GZIP"
#endif

#ifndef Z_SUFFIX
#  define Z_SUFFIX ".gz"
#endif

#ifdef MAX_EXT_CHARS
#  define MAX_SUFFIX  MAX_EXT_CHARS
#else
#  define MAX_SUFFIX  30
#endif

#ifndef MAKE_LEGAL_NAME
#  ifdef NO_MULTIPLE_DOTS
#    define MAKE_LEGAL_NAME(name)   make_simple_name(name)
#  else
#    define MAKE_LEGAL_NAME(name)
#  endif
#endif

#ifndef MIN_PART
#  define MIN_PART 3
   /* keep at least MIN_PART chars between dots in a file name. */
#endif

#ifndef EXPAND
#  define EXPAND(argc,argv)
#endif

#ifndef RECORD_IO
#  define RECORD_IO 0
#endif

#ifndef SET_BINARY_MODE
#  define SET_BINARY_MODE(fd)
#endif

#ifndef OPEN
#  define OPEN(name, flags, mode) open(name, flags, mode)
#endif

#ifndef get_char
#  define get_char() get_byte()
#endif

#ifndef put_char
#  define put_char(c) put_byte(c)
#endif
